---
generated_at: 2026-02-03 10:45:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-デフォルトレイアウト (Default Layout)

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/client/components/builtin/layout.tsx` L1-13 - コンポーネント全体
- E-02: `packages/next/src/client/components/builtin/layout.tsx` L1 - Reactインポート
- E-03: `packages/next/src/client/components/builtin/layout.tsx` L3-6 - 関数シグネチャとプロパティ型
- E-04: `packages/next/src/client/components/builtin/layout.tsx` L8-12 - JSXテンプレート
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` L11 - 画面情報定義
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` L26-27 - 関連機能情報

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ユーザー未定義時のデフォルトレイアウトとして機能 | E-05 | ○ |
| C-02 | 最小限のhtml/body構造のみを提供 | E-04 | ○ |
| C-03 | childrenプロパティ(React.ReactNode型)を受け取る | E-03 | ○ |
| C-04 | lang属性やメタデータを含まない | E-01 | ○ |
| C-05 | 'use client'ディレクティブなし（Server Component） | E-01 | ○ |
| C-06 | Reactをインポート | E-02 | ○ |
| C-07 | default exportされている | E-01 | ○ |
| C-08 | App Routerで使用 | E-05 | ○ |
| C-09 | レイアウト(Layouts)が主機能 | E-06 | ○ |
| C-10 | App Routerのレイアウト階層でのフォールバック | E-06 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードから直接確認可能。コンポーネントが極めてシンプル（13行）で誤解の余地が少ない。

## 6) レビュアーチェックリスト（最小）
- [ ] html/body構造のみで追加属性がないことが正確に記述されているか確認
- [ ] フォールバックとしての使用条件（ユーザーレイアウト未定義時）が正確か確認
